# Updating goal-setting theory in physical activity promotion: a critical conceptual review

Christian Swann, Simon Rosenbaum, Alex Lawrence, Stewart A. Vella, Desmond McEwan & Panteleimon Ekkekakis

To cite this article: Christian Swann, Simon Rosenbaum, Alex Lawrence, Stewart A. Vella, Desmond McEwan & Panteleimon Ekkekakis (2021) Updating goal-setting theory in physical activity promotion: a critical conceptual review, Health Psychology Review, 15:1, 34-50, DOI: 10.1080/17437199.2019.1706616

To link to this article: https://doi.org/10.1080/17437199.2019.1706616

# Updating goal-setting theory in physical activity promotion: a critical conceptual review

Christian Swann a,b, Simon Rosenbaum $\textcircled{1}$ c,d, Alex Lawrencea,b, Stewart A. Vella $\textcircled{1}$ e , Desmond McEwan $\oplus ^ { \mathsf { f } }$ and Panteleimon Ekkekakis g

a School of Health and Human Sciences, Southern Cross University, Coffs Harbour, Australia; b Centre for Athlete Development, Experience and Performance, Southern Cross University, Coffs Harbour, Australia; c School of Psychiatry, Faculty of Medicine, University of New South Wales, Australia; d Black Dog Institute, Sydney, Australia; e Global Alliance for Mental Health and Sport, School of Psychology, Faculty of Social Sciences, University of Wollongong, Australia; f Department for Health, University of Bath, Bath, UK; g Department of Kinesiology, Iowa State University, Ames, Iowa, USA

# ABSTRACT

Goal-setting is a widely used and accepted strategy for promoting physical activity. Locke and Latham’s goal-setting theory is the primary theoretical framework for setting goals in psychology and plays a prominent role in physical activity promotion. Recently, however, there have been calls to reconsider current goal-setting practice in this field. Therefore, we aimed to critically review and update the application of goal-setting theory in physical activity promotion, by examining core developments in this theory since 1990. Current practice relies on setting specific ‘performance’ goals as a means of increasing physical activity (e.g., 10,000 steps; national physical activity guidelines). This approach was initially consistent with key tenets of goal-setting theory. However, since 1990 this theory has evolved to differentiate between performance and learning goals. Both goal types are context-dependent and it is now recognised that, in some cases, performance goals can even be detrimental to the achievement of desired outcomes. Consequently, current practice may be theoretically appropriate for physically active individuals but a different approach (e.g., learning goals) may be preferable for inactive individuals who are new to physical activity (i.e., most of the population). We conclude by discussing implications for policy, research, and practice in goal-setting for physical activity promotion.

# ARTICLE HISTORY

Received 16 September 2019   
Accepted 13 December 2019

# KEYWORDS

Exercise; goals; guidelines; health; practice; psychology

The physical inactivity pandemic (Kohl et al., 2012) is one of the greatest public health challenges facing most industrialised nations, responsible for over five million deaths globally each year (Ekelund et al., 2016). Despite concerted efforts to increase physical activity (PA) through modes such as public health messaging and PA policies (Schwartz, Rhodes, Bredin, Oh, & Warburton, 2019), interventions designed to increase public participation in, and adherence to, PA have yielded only modest results (Gourlan et al., 2016; Howlett, Trivedi, Troop, & Chater, 2019; Rhodes, Janssen, Bredin, Warburton, & Bauman, 2017). The average effect is small and short-lived, comparable to the so-called ‘question-behaviour effect’ or ‘mere measurement effect’ – that is, the change in PA that occurs as a result of simply completing a measure of PA (van Sluijs, van Poppel, Twisk, & van

Mechelen, 2006; Wilding et al., 2016). Compliance with physical activity guidelines in the United States ‘was not significantly improved from 2007–2008 through 2015–2016’ but, in contrast, ‘there was a significant increase in time spent on sedentary behaviour over time’ 1 (Du et al., 2019, p. 9). Furthermore, there are very high dropout rates among those who start PA, fitness, and exercise programmes. For example, the average rate of dropout from exercise intervention studies, which in most cases include components designed to prevent attrition, has been estimated at $45 \%$ (Marcus et al., 2006), while more recent estimates from community or commercial exercise programmes (e.g., membership of fitness centres) found that dropout reached $4 7 \%$ by the second month, $8 6 \%$ by the sixth month, and $9 6 \%$ by the 12th month (Sperandei, Vieira, & Reis, 2016). These issues, whereby PA promotion leads to high dropout and ultimately little or no progress at the population level, suggest that there may be problems in how PA is promoted. From this perspective, it is imperative to critically examine core ingredients of PA promotion initiatives.

# Goal-setting and PA promotion

A goal is defined as ‘what an individual is trying to accomplish; it is the object or aim of an action’ (Locke, Shaw, Saari, & Latham, 1981, p. 126), such as ‘to attain a specific standard of proficiency, usually within a specified time limit’ (Locke & Latham, 2002, p. 705). Goal-setting is one of the most frequently used components of behavioural interventions aimed at health-behaviour change (Michie, West, Sheals, & Godinho, 2018), including those designed to promote PA participation and maintenance (e.g., Howlett et al., 2019; Nigg, Borrelli, Maddock, & Dishman, 2008). For example, a review of PA interventions and behaviour change techniques for healthy inactive adults found that goal-setting was the most frequently used strategy $( 8 4 . 6 \%$ of studies; Howlett et al., 2019). Strecher et al. (1995) noted that

In practice, goal setting is an implicit or explicit part of almost all health-related intervention. The question is not whether goal setting will be used, but whether it will be applied inconsistently and nonspecifically, or systematically with regard to research findings. (p. 198)

Goal-setting is particularly relevant to PA promotion at the individual level, as: goals are prescribed to individuals by exercise practitioners; the presumed motivational function of activity trackers is largely based on goal-setting principles; and individuals may adopt national/worldwide PA guidelines as a goal to achieve. Goal-setting is recommended in practice guidelines issued by major organizations, including the American College of Sports Medicine (Nigg, 2013), Moving Medicine (www.movingmedicine.ac.uk) and the American Heart Association (Artinian et al., 2010), while the National Institute for Health and Care Excellence (2014) stated that goal-setting should be present in any behaviour change intervention. Goals are relevant as motivational tools to the entire gamut of interventions, from face-to-face consultations with individual clients, including those based on the popular method of motivational interviewing (Markland, Ryan, Tobin, & Rollnick, 2005; O’Halloran et al., 2014; Resnicow & McMaster, 2012), to scalable e-health interventions based on smartphones and wearable devices (e.g., Foster, Richards, Thorogood, & Hillsdon, 2013) to community-wide social-marketing campaigns (e.g., goals of 150 min per week or 10,000 steps; TudorLocke et al., 2011).

Furthermore, extensive evidence suggests that goal-setting is an effective strategy. McEwan et al. (2016) reported a medium effect size $( d = . 5 5 , 9 5 \% \mathsf { C l } = . 4 3 \mathrm { - } . 6 7 )$ from goal-setting interventions on PA, based on 45 studies and 52 controlled interventions assessed at post-intervention time-points (i.e., follow-up data were not assessed). These authors concluded that goal-setting interventions were effective at post-intervention regardless of research settings, modes of delivery, lengths of programme duration, type of PA prescribed, type of measure used to assess PA, and irrespective of age, baseline weight, activity status prior to the intervention, or sex of participants, and who prescribed the goal (McEwan et al., 2016). Given the centrality of goals in efforts to promote PA and exercise on a global scale, it is imperative to maintain a critical outlook on theoretical postulates and the translation of these postulates into practice.

# The need to reconsider current practice

Recently, questions have been raised regarding current goal-setting practice in physical activity promotion. For example, McEwan et al. (2016) reported that goal-setting was effective post-intervention regardless of whether theory was used to guide interventions, and regardless of goal specificity. In other words, goal-setting had a medium effect size on PA even when the prescribed goals were vaguely defined (e.g., to ‘be more active’). McEwan et al. (2016) concluded that ‘it is possible that vague goals were advantageous for these participants who were in the early stages of learning to be physically active’ (p.82). This finding goes against conventional wisdom and the current practice of setting specific goals, yet it is in line with goal-setting theory, which states: ‘trying for specific, challenging goals may actually hurt performance in certain circumstances (such as) in the early stages of learning a new, complex task’ (Latham & Locke, 1991, p. 229). The majority of samples included in the McEwan et al. (2016) meta-analysis were insufficiently active, and therefore likely to have been at the early stages of learning to be active.

Subsequently, Swann and Rosenbaum (2018) suggested that if PA adoption is considered a complex task, then theory and evidence would suggest that, for participants in the early stages of learning (i.e., the majority of the population), current practice in goal-setting may not be optimally effective. Put differently, arguably, there may have been ‘an oversimplification or misunderstanding in the application of goal-setting theory and … [that] something has been lost in translation from theory to practice’ (p.486). It appears that there has been a failure to differentiate when specific, challenging goals vs. other goal types (e.g., do-your-best goals, learning goals) should be set. As such, there is a need to question commonly held assumptions for ‘best practice’ in goal-setting for PA promotion, especially for those who are most in need of intervention (Beauchamp, Crawford, & Jackson, 2019; Swann & Rosenbaum, 2018). If current goal-setting messages and practices are, in fact, misapplied or applied in a suboptimal manner, this issue has the potential to undermine policy, research, and practice in ongoing efforts to increase PA.

# Importance of a goal-setting theory perspective

Using a theory to guide intervention is often considered as best practice in health promotion (Glanz & Rimer, 2005; Prestwich, Webb, & Conner, 2015). Theory provides a framework to test hypotheses, identify constructs that influence behaviour, and suggest which techniques should be incorporated in interventions (Prestwich et al., 2015). Glanz and Rimer (2005) summarised that ‘Interventions based on health behaviour theory are not guaranteed to succeed, but they are much more likely to produce desired outcomes’ (p. 1). As such, a theoretical perspective of current goal-setting practice may provide important insights into how researchers, practitioners, and policy makers can work towards ‘best practice’.

While many theories in health and behaviour change incorporate goals (e.g., Social Cognitive Theory; Bandura, 1986), goal-setting theory has a central focus on the nature and process of setting goals. The goal-setting theory proposed by Locke and Latham (1990, 2002, 2013) is a prominent guide for research and interventions on PA promotion and maintenance. Several systematic reviews, meta-analyses, and narrative reviews have been published on the effects of goal-setting on health behaviours, including PA, with a primary focus on goal-setting theory (Bodenheimer & Handley, 2009; Epton, Currie, & Armitage, 2017; McEwan et al., 2016; Pearson, 2012; Shilts, Horowitz, & Townsend, 2004; Shilts, Townsend, & Dishman, 2013; Strecher et al., 1995; Williams, 2013). Similarly, goal-setting theory has informed a range of PA interventions (e.g., Dishman, DeJoy, Wilson, & Vandenberg, 2009), including large-scale programmes based on the popular target of 10,000 steps (e.g., Anson & Madras, 2016; Moon, Yun, & McNamee, 2016).

Furthermore, respected professional organizations specifically cite goal-setting theory in their practice guidelines for PA promotion (e.g., the American College of Sports Medicine’s [ACSM] guidelines for exercise testing and prescription; 2017). Current practice in goal-setting for PA promotion centres on goal specificity and difficulty. For example, in a section on best practice strategies, ACSM’s Behavioural Aspects of PA and Exercise (Nigg, 2013) cites Locke and Latham’s theory when noting that: ‘Research has consistently demonstrated that setting goals that are specific, concrete, and challenging rather than vague and easy to achieve results in better performance’ (p. 91). Indeed, common guidelines for PA revolve around specific, concrete (and, in many cases, challenging) targets, such as to do at least $1 5 0 \mathrm { \ m i n }$ of at-least moderate-intensity aerobic PA throughout the week, with muscle-strengthening activities done on two or more days a week (World Health Organisation, 2010). Thus, Locke and Latham’s goal-setting theory plays a prominent role in research and practice in PA promotion and maintenance, and individuals setting goals for PA are often (implicitly or explicitly) encouraged to set goals in accordance with goal-setting theory.

# Aims

As discussed above, recent articles (Beauchamp et al., 2019; McEwan et al., 2016; Swann & Rosenbaum, 2018) suggest that current practice in PA promotion may not be aligned with the core tenets of goal-setting theory in terms of what type of goal should be set in what circumstances. An important next step, therefore, is to critically review the relevant propositions within goalsetting theory and their application to PA promotion. While goal-setting theory encompasses a relatively broad range of propositions, this review will focus specifically on the goal types, moderating factors, and mediators outlined by Locke and Latham.

A critical conceptual review was the preferred approach for two reasons: (i) the primary focus was on providing a goal-setting theory perspective rather than on reviewing empirical findings; and (ii) a systematic review and meta-analysis of goal-setting in PA interventions was conducted recently (McEwan et al., 2016) and raised the issues which the present review seeks to address. Specifically, we reviewed core goal-setting literature and key papers that have contributed to the development of goal-setting theory since it was first formalised in 1990. We also reviewed relevant literature from PA promotion which discussed current practice (e.g., mass-media campaigns), goal-setting, goal-setting theory, or the relevant tenets of goal-setting theory (goal types, moderators, and/or mediators) in PA promotion. Providing a goal-setting theory perspective may identify inconsistencies between theory and practice, enable examination of consequences or implications of any such inconsistencies, and provide insight into how best practice should be shaped in the future. Therefore, we aimed to: (i) critically review the core tenets of goal-setting theory and their application to PA promotion; (ii) discuss possible consequences and negative implications of setting PA goals inappropriately; (iii) consider alternative goal types that are consistent with goal-setting theory; and (iv) identify future directions for policy, research and practice. In doing so, this review seeks to address calls to reconsider commonly held assumptions regarding ‘best practice’ in goal-setting for PA promotion (Beauchamp et al., 2019; McEwan et al., 2016; Swann & Rosenbaum, 2018), to provide a theoretically informed basis for moving forward in this field, and ultimately improve efforts to help insufficiently active individuals achieve the health benefits of regular PA.

# Core tenets of goal-setting theory

# Overview and evolution of goal-setting theory

Goal-setting theory was formalised in 1990 (Locke & Latham, 1990) and focuses on the core properties of effective goals, with a primary interest in predicting, explaining, and influencing performance (Locke & Latham, 2002). There are two core findings upon which goal-setting theory is based (e.g., Locke & Latham, 2013). First, the theory postulates a linear relationship between goal difficulty and performance, conditional on four moderators (ability, feedback, commitment, and resources – see below). The theory predicts that the higher the goal, the better the performance and that performance will level off or decrease only when the limits of one’s ability are reached or when commitment lapses (Locke & Latham, 2002). Second, specific, difficult goals are theorised to lead to higher performance than no goals or vague, abstract goals such as ‘do your best’. Importantly, ‘goal specificity in itself does not necessarily lead to high performance because specific goals vary in difficulty’ (Locke & Latham, 2002, p. 706). As such, Locke and Latham largely advocate for specific, challenging goals as being the most effective for increasing performance.

Four mediators are proposed to explain why specific, challenging goals would increase an individual’s performance (e.g., Latham, 2016). First, specific goals are believed to involve the choice to take action, through which individuals can focus on the task and have direction or purpose in what they do. Second, specific, challenging goals can stimulate effort, whereby the more challenging the specific goal, the more effort is likely to be expended. Third, when a specific, difficult goal is set, individuals display persistence in their pursuit of the goal. Fourth, setting a specific, challenging goal commonly cues an individual’s existing strategies in order to attain it (Latham, 2016).

Initially, goal-setting theory solely advocated specific, challenging goals as evidence suggested that this goal type was more effective than no goals or vague goals such as to ‘do-your-best’ (Locke & Latham, 1990, 2002, 2013). However, since the theory was formalised in 1990, goalsetting theory has evolved in several important ways (see Locke & Latham, 2015 for a discussion). Of them, ‘Arguably the most important finding subsequent to 1990 is the distinction between a learning goal and a performance goal’ (Locke & Latham, 2015, p. 116). It is suggested that both performance and learning goals should be specific and challenging, but that researchers/practitioners should distinguish between these goal types and set each type of goal only in appropriate contexts (Locke & Latham, 2013).

The key feature that distinguishes between performance and learning goals is the focus of the individual during the execution of the task. Performance goals ‘focus on the achievement of specific tasks according to certain standards of proficiency’ (Tasa, Whyte, & Leonardelli, 2013, p. 402). Moreover, a performance goal ‘frames the goal instructions so that an individual’s focus is on a specific task outcome’ (Seijts, Latham, & Woodwark, 2013, p. 196). Implicitly, Locke and Latham referred to performance goals when they first formalised goal-setting theory and, therein, advocated for the importance of setting goals that are specific.

Conversely, learning goals are defined as ‘a desired number of strategies, processes, or procedures to be developed in order to master a task’ (Locke & Latham, 2015, p. 116), for example, to ‘discover and implement four shortcuts to performing this scheduling task’ (Seijts et al., 2013, p. 197).

Learning goals were not studied until after goal-setting theory was first formalised in 1990 (e.g., Winters & Latham, 1996) but have since been integrated into the theory. Although do-your-best goals in the early stages of learning led to higher performance than a performance goal, learning goals have been shown to lead to the highest level of performance (Winters & Latham, 1996). The failure to distinguish learning from performance goals may be one reason why some studies failed to obtain findings consistent with goal-setting theory, especially when participants were in the early stages of learning (e.g., Locke & Latham, 2013). Indeed, in their highly cited paper in the American Psychologist, Locke and Latham (2002, p. 714) referred to ‘the proper use of learning versus performance goals’ as one of the core properties of goal-setting theory.

# Application to PA promotion

Most goal-setting guidance for PA is based on goals that meet the definition of performance goals (i.e., goals that have a focus on the achievement of outcomes). Examples of prominent PA promotion initiatives that involve the achievement of specific outcomes include: the 10,000 steps challenge (based on either 10,000 steps per day or incremental increases such as 1500 more steps than last week); the ‘Find Your ${ 3 0 ^ { \prime } }$ campaign in Australia (i.e., engage in $3 0 \mathsf { m i n }$ of physical activity every day); the Daily Mile initiative (i.e., run or jog for $1 5 \mathrm { { m i n } }$ every day); the Active 10 program by Public Health England (e.g., based on completing bouts of 10 min of walking per day); and World

Health Organisation physical activity guidelines (e.g., at least 150 min of moderate-intensity aerobic PA, or at least 75 min of vigorous-intensity aerobic PA throughout the week, or an equivalent combination). That is, PA is typically promoted through highly prominent, wide-reaching initiatives expressed in terms of performance goals.

This evolution of goal-setting theory has several important implications for PA promotion. First, this evolution means that it is no longer theoretically sound to simply refer to ‘specific, challenging goals’ without specifying what type of goal is used (i.e., performance or learning). Nevertheless, this continues to be the case in several prominent examples of professional guidance in the field of PA promotion. Second, goal-setting is now clearly framed as context-dependent: ‘like all behavioural science interventions, goal effectiveness is based on context factors; thus goals have potential drawbacks’ (Latham & Locke, 2006, p. 338). That is, certain goal types (i.e., performance or learning goals) are useful in certain situations but can be detrimental if set inappropriately. Therefore, it is important to consider under what circumstances performance goals may be appropriate (i.e., what are the moderators of performance goals?), and what the consequences of setting/pursuing performances goals inappropriately may be.

# ‘Ignoring the moderators in goal-setting theory is done at one’s peril’

Goal-setting theory specifies four2 moderators that are postulated to determine when/whether a performance goal or a learning goal should be set (e.g., Locke & Latham, 2015, 2019), including ability, commitment, feedback, and situational resources. Latham (2016) emphasised that a specific, challenging, performance goal leads to higher performance than an easier goal, a vague goal, or no goal only under certain conditions. As Latham (2016) put it, ‘ignoring the moderators in goal-setting theory is done at one’s peril’ (p. 5). Similarly, Locke and Latham’s (2002) highly cited paper specifies the ‘essential elements of goal-setting theory’ (p. 714), which include various moderators. Thus, if performance goals are to be set for PA promotion based on goal-setting theory, it is imperative that these moderators be considered.

# Ability

First, individuals must have the ability to attain a specific, challenging performance goal: ‘People cannot attain goals if they do not know how to do so’ (Locke & Latham, 2019, p. 98). In terms of PA promotion, this issue assumes that the individual has the ability to achieve PA goals. Such abilities could be cognitive (e.g., knowledge of what counts as moderate-intensity PA, or understanding of factors such as pacing while jogging) or physical (e.g., having the aerobic capacity to achieve a certain exercise goal, or knowing how to perform strength exercises before aiming to achieve related goals in the national PA guidelines). Williams (2013) summarised that: ‘Studies in a variety of settings have shown that specific, difficult performance goals may be detrimental to performance when people have yet to acquire the requisite knowledge, skills, or abilities for a task’ (p. 381–382). Thus, without the requisite ability, performance goals should not be set.

Task complexity. Locke and Latham often discussed task complexity relative to the moderator of ability (e.g., 2013), for example, in terms of whether the individual is at the early stages of learning a complex task (Latham & Locke, 1991). PA and exercise are complex behaviours (Dishman, 1994; Rhodes & Nigg, 2011). Recently, Swann and Rosenbaum (2018) suggested that PA has high component complexity (e.g., attention to components such as frequency, intensity, duration, mode, and cost of PA), coordinating complexity (e.g., scheduling, organising, and prioritising PA), and dynamic complexity (e.g., maintaining motivation, commitment, and overcoming setbacks). In such situations, according to goal-setting theory, performance goals should not be set: ‘individuals should avoid setting a specific, challenging [performance] goal until they have acquired the ability (i.e., knowledge and skill) to perform the task’ (Seijts et al., 2013, pp. 195–196). That is, according to goal-setting theory, PA should not be promoted via specific, challenging goals based on task outcomes and achieving certain standards of proficiency to individuals at the early stages of learning to be active.

# Commitment

Goal commitment was identified as another moderator variable: ‘A goal that one is not committed to attain will not affect that person’s actions’ (Locke & Latham, 2019, p. 98). Put differently, goal commitment occurs to the extent that the goal is seen by the person as important, and specific, challenging performance goals would be appropriate only if the individual is already committed to achieving the goal (e.g., Klein, Cooper, & Monahan, 2013). Conversely, such goals may not be appropriate for helping or motivating inactive individuals to become active. Thus, setting performance goals to motivate individuals to become active (as is currently done by PA promotion campaigns, including national guidelines) does not align with goal-setting theory. Indeed, the fact that most people remain inactive suggests they are not committing to the national PA guidelines as a goal.

# Feedback

Individuals must be able to receive feedback on their performance in relation to the performance goal they are striving to attain (Bandura & Locke, 2003). Strecher et al. (1995) stated that ‘setting goals and then providing no information about goal attainment defeats the rationale for setting goals’ (p. 194). Without such feedback, individuals lack information to understand whether they should adhere to or change their strategy for goal attainment (Locke & Latham, 2002, 2013, 2019). Hence, individuals need to be able to receive and understand feedback on their progress towards (or away from) their PA goals. Indeed, setting performance goals alone may not be sufficient, and other strategies (e.g., self-monitoring) may also be required to facilitate progress toward the goal. Without the provision or identification of mechanisms for receiving feedback, performance goals are not appropriate according to goal-setting theory.

# Situational resources

The requisite resources must be available for goal attainment, and situational constraints can influence the ability and/or commitment of individuals to achieving their goals (Latham, 2016). In a PA context, such resources have been discussed extensively in terms of barriers and facilitators to being active (e.g., access to fitness facilities and welcoming community environments; Schwartz et al., 2019). Importantly, according to goal-setting theory, unless the individual has the required resources (e.g., access to indoor equipment during winter), it is not considered appropriate to set a specific, challenging performance goal.

# Summary and critique

Current practice in goal-setting for PA promotion typically relies on the use of performance goals, which were initially the only form of goal advocated by Locke and Latham. However, goal-setting theory has evolved since Locke and Latham’s (1990) first iteration, and it is now important to clarify which type of specific, challenging goal is being used. According to goalsetting theory, a performance goal should only be set in very specific instances – including when the individual has the necessary knowledge, ability, commitment, feedback, and resources to achieve it (e.g., Locke & Latham, 2019). In such cases, higher performance can be expected to occur through the mediators of specific, challenging performance goals: a choice to take action; increased effort; persistence; and cuing of existing strategies (Locke & Latham, 2002, 2013). Notably, such situations appear to align with individuals who are already active; that is, the bulk of current goal-setting guidance in PA promotion is targeting a minority of individuals, and is theoretically unsound (and possibly detrimental – see below) for the large majority.

Furthermore, current practice does not account for these moderators which is another example of misapplication of theory. Setting performance goals in the absence of necessary moderators means that they are likely to be less effective, and could even have detrimental consequences: ‘setting an exercise goal for a person not interested in exercising (i.e., a “precontemplator”) will probably have little effect, or may even be counterproductive’ (Strecher et al., 1995, p. 191). Thus, the theoretical relevance of setting specific performance goals for inactive individuals is questionable: performance goals are essentially about getting more out of people once they already know how to do the task, and as such, goal-setting theory suggests that performance goals should not be set for inactive individuals (as is currently the case). Hence, it is important to consider possible consequences and implications of inappropriately set goals – and the majority of guidance upon which PA promotion initiatives are currently based.

# Detrimental effects of inappropriate goal-setting

Since Locke and Latham’s (1990) initial iteration of goal-setting theory, evidence has emerged which indicates that specific, challenging performance goals can be detrimental to performance in certain circumstances. Locke and Latham, as well as other researchers, have addressed the possible detrimental effects of goal-setting and how to avoid them (e.g., Drach-Zahavy & Erez, 2002; Latham & Locke, 2006; Ordóñez, Schweitzer, Galinsky, & Bazerman, 2009). At this point, within the goal-setting literature, ‘possible pitfalls of goal-setting are well known’ (Locke & Latham, 2015, p. 117) and ‘the potential risks of goal pursuit should always be examined’ (Latham & Locke, 2006, p. 337). It is therefore important to consider these possible maladaptive or detrimental effects specifically within PA contexts.

# Stress, anxiety, pressure, and threat appraisals

One of the main detrimental effects of goals is that they can lead to stress, anxiety, and perceived pressure (Latham & Locke, 2006; Locke & Latham, 2002). Stress, anxiety and pressure can result from setting unachievably high goals (e.g., daily/weekly recommendations that are unrealistic for the individual’s present PA level or level of physical conditioning), or if there are too many challenging goals (e.g., too many components or required behaviours to increase PA; Latham & Locke, 2006). Moreover, studies have found that specific, challenging performance goals can be appraised as threatening (Drach-Zahavy & Erez, 2002). Latham and Locke (2006) highlighted that: ‘A … potential problem with goal setting is that it [the goal] may be viewed as a threat rather than a challenge … [and] when people view a goal as threatening … their performance drops’ (p. 333). Thus, individuals pursuing current goal-setting guidance in PA may experience stress, anxiety, pressure, and threat appraisals as a result. These factors have been highlighted as barriers/causes of low participation in, and dropout from, PA. For example, stress impairs efforts to be physically active (Burg et al., 2017; Stults-Kolehmainen & Sinha, 2014), and reduces self-efficacy to meet exercise goals (Stetson, Rahn, Dubbert, Wilner, & Mercury, 1997).

# Inhibition of learning

Performance goals can undermine learning and strategy development because they encourage the use of simple means-end strategies that do not focus on learning the rules or requirements of the task (e.g., Sweller & Levine, 1982). Seijts and Latham (2005, p. 126) noted that:

The assignment of a specific challenging performance goal makes some people so anxious to perform at a high level that they scramble to discover the task-relevant strategies in an unsystematic way. In doing so, they fail to learn in a timely fashion the most efficient ways to accelerate their effectiveness.

When facing a complex task, individuals who are narrowly focussed on a performance goal will be less likely to try alternative methods that could help them learn how to perform that task, and in turn may prevent learning (Ordonez et al., 2009, p. 13). Thus, specific, challenging performance goals may induce focus on immediate performance outcomes (such as to achieve 30 min of moderate-intensity PA five times per week) but divert necessary attention away from strategy development and inhibit learning (e.g., failing to learn different ways of meeting the PA guidelines, or finding one’s own preferred mode of exercising; Drach-Zahavy & Erez, 2002).

# Unethical behaviour

Evidence suggests that goal-setting can induce unethical behaviour (e.g., Latham & Locke, 2006). For example, Schweitzer, Ordóñez, and Douma (2004) found that participants were more likely to misrepresent their performance when they had a specific, challenging goal than when they did not, particularly when their actual performance was just short of achieving the goal. Ordóñez et al. (2009) suggested that goal-setting can promote two types of unethical or cheating behaviour: first, using unethical methods to reach a goal (e.g., taking a short cut during a race); and second, misrepresenting one’s performance (e.g., reporting that a goal has been met when in fact it has not). The issue that goal-setting can sometimes motivate unethical behaviour may have implications for self-reporting methods in PA interventions, whereby participants could either overstate the PA they completed, or could find spurious methods to reach their goal (e.g., by shaking a pedometer to reach one’s daily step count). One example of such behaviour was reported in China, where health insurance companies provide discounted premiums for people who consistently reach certain daily step counts. Remarkably, this has resulted in the development of electronic cradles, designed to rock smartphones and ‘cheat the step counter’ (Morris, 2019). Thus, goal-setting can motivate unethical behaviour, such as ‘cheating’, in pursuing PA targets.

# Failure to achieve goals

According to Latham and Locke (2006), ‘Errors and failures inevitably occur in the pursuit of high goals’ (p. 335). Achievement of goals is actually not the primary aim of goal-setting theory; instead, goal-setting is simply a mechanism for enhancing task performance regardless of whether the goal is achieved (Playford, Siegert, Levack, & Freeman, 2009). In many cases in PA research, participants do not achieve the specific performance goals they set. For example, in a one-week intervention, $6 9 \%$ of participants achieved specific step count goals (i.e., almost a third of participants failed to meet their goal; Moon et al., 2016). In a longer trial, Conroy et al. (2011) reported that the mean proportion of overweight adults meeting step count goals dropped from approximately $7 5 \%$ at week 3 to approximately $2 2 \%$ at week 24; that is, by the end of the intervention, almost $80 \%$ of participants failed to meet their goals.

Whether self-set, set participatively, or assigned, specific goals have the potential to create an allor-nothing scenario. By their very nature, there is no such thing as partial achievement of a specific goal – one either achieves the specific goal or does not – so individuals should be praised for making goal progress. However, when goals are not achieved, dissatisfaction occurs, which can lead to an impairment of subsequent performance (Locke & Latham, 2002). Previous failures can elicit negative emotions that lead to low performance, for example, by causing a shift in attention from problemsolving to thoughts about personal shortcomings or consequences of further failure (Strecher et al., 1995). In turn, this could lead to lowering the goal or abandoning it altogether – particularly for those with low self-efficacy (Bandura, 2013). This issue means that participants are exposed to failure, which in turn can affect psychological factors such as self-concept, self-efficacy, and motivation, and can require other skills and strategies to overcome such ‘relapses’ – even though participants may still have achieved meaningful increases in PA. Thus, when setting specific goals, there is inherently a risk of failure, which can be psychologically harmful for individuals trying to become more active.

# Summary

Specific and challenging performance goals can have a range of detrimental effects when set inappropriately – particularly in reference to complex tasks, such as PA and exercise – which can impact on psychological factors known to be linked to long-term engagement (e.g., stress and selfefficacy). As such, it is important to anticipate problems and possible detrimental effects when setting goals (e.g., Oettingen, Wittchen, & Gollwitzer, 2013). Evidence indicates that inappropriately set goals (e.g., when moderating conditions are not met) can lead to stress, pressure, threat appraisals, inhibition of learning, greater attentional demands, unethical behaviour, and perceptions of failure (e.g., Latham & Locke, 2006). Such negative consequences could ultimately be detrimental to individuals’ attempts to be more active. Therefore, current goal-setting practice – based on setting specific, challenging performance goals without considering moderating factors – may be contributing to the observed high rates of dropout and physical inactivity. That is, current goal-setting practice could be harmful to psychological factors relating to long-term participation and adherence, which, in turn, could reduce the likelihood of individuals achieving the health benefits of exercise and PA.

# Alternative approaches according to goal-setting theory

Given the possible risks and detrimental effects of goal-setting discussed above, it is important to consider alternative approaches (i.e., compared to specific, challenging performance goals) advocated by goal-setting theory. The alternative goal types considered by Locke and Latham are learning goals and do-your-best goals.

# Do-your-best goals

Goal-setting theory originally focussed on comparisons between specific, challenging goals and ‘doyour-best’ goals (e.g., Latham & Locke, 1991). In their overview of goal-setting theory as outlined in 1990, Locke and Latham highlighted that: ‘on a task that is complex for an individual, a do-your-best goal may work better than a specific, hard goal’ (2013, p. 6). Do-your-best goals are generally assumed to be inferior to specific, challenging goals, and the merits of do-your-best goals are often overlooked. Indeed, Seijts and Latham (2005) highlighted:

That setting specific challenging performance goals can sometimes lead to worse performance than urging individuals to do their best is at first glance astonishing in that this conclusion is contrary to the weight of over a quarter of a century of accumulated findings in the behavioural sciences (p.127).

Since 1990, however, studies have reported that learning goals are more effective than do-yourbest goals and performance goals in complex tasks (e.g., Drach-Zahavy & Erez, 2002; Seijts & Latham, 2001; Seijts, Latham, Tasa, & Latham, 2004; Winters & Latham, 1996; ). Indeed, a meta-analysis reported that the benefit of setting a learning goal instead of a do-your-best goal was significant, with a medium effect size (Seijts et al., 2013). Thus, Locke and Latham now explicitly advocate for learning goals, rather than do-your-best goals, as an often-appropriate alternative to performance goals.

# Learning goals

Learning goals focus on ‘the number of ideas or strategies one acquires or develops to accomplish the task effectively’ (Locke & Latham, 2002, p. 706). They may involve idea generation, critical evaluation of ideas, and the implementation of one or more of those ideas (Seijts & Latham, 2012). Thus, where specific, performance goals are about achieving a desired outcome, learning goals are about developing processes or strategies involved in performing the task effectively (Locke & Latham, 2002,

Table 1. Examples of performance and learning goals in goal-based physical activity promotion initiatives.   

<html><body><table><tr><td>Goal Type</td><td>Example of Application in Physical Activity Promotion</td></tr><tr><td rowspan="5">Performance Goals</td><td>10,000 steps per day,or to increase last week&#x27;s average by 1,500 steps</td></tr><tr><td>30 min of physical activity per day (e.g., Find Your 30)</td></tr><tr><td>Run or jog for15 min every day (e.g., Daily Mile) At least 150 min of moderate-intensity aerobic physical activity,orat least75 min of vigorous-intensity</td></tr><tr><td>aerobic physical activity throughout the week,oran equivalent combination (e.g.,World Health</td></tr><tr><td>Organisation)</td></tr><tr><td rowspan="4">Learning Goals</td><td>Identify three effective strategies to increase your daily step count</td></tr><tr><td>ldentifyand implement four strategiesto reach 30min of physical activityper day</td></tr><tr><td>Find three ways of fiting a 15 min run or jog into your day</td></tr><tr><td>Findfive ways to accumulate at least 150 min of moderate intensityaerobic physical activity,oratleast 75 mir of vigorous-intensity aerobic physical activity,or an equivalent combination,throughout the week</td></tr></table></body></html>

Note: Learning goals should also be specific and challenging in order to be most effective (e.g., Locke & Latham, 2013), so the number of strategies identified within a learning goal should vary depending on the individual’s appraisal.

2013). Furthermore, ‘Research on learning goals has shown that the core findings are all but the same as those of performance goals. Consistent with goal setting theory, challenging learning goals lead to higher performance than low learning goals’ (Seijts et al., 2013, pp. 209–210). In the context of PA promotion, examples of learning goals might be to ‘find four ways to increase your daily step count this week’ or to ‘identify three effective strategies to increase the amount of time you spend being physically active today.’ 3 Table 1 presents examples of performance goals, and equivalent learning goals, within common PA promotion initiatives.

# When should learning goals be set?

Learning goals are typically advocated when the individual is new to a complex task (e.g., Seijts et al., 2013). Indeed, ‘A rule of thumb is to set a learning goal when an individual lacks the ability to perform the task’ (Locke & Latham, 2015, p. 116). Other situations wherein learning goals, rather than performance goals, should be set include: when learning rather than just performance motivation is required (Latham & Locke, 2006, 2007; Williams, 2013); when individuals have lower cognitive ability (Latham, Seijts, & Crim, 2008); and ‘when negative feedback is given on the performance of a task that is experienced as highly complex’ (Locke & Latham, 2019, p. 100). It is also suggested that ‘high commitment to a learning goal is essential for that goal to be effective in increasing performance’ (Latham & Seijts, 2016, p. 228), although this finding appears to hold primarily when high learning goals are set (i.e., commitment made less of a difference to performance on low learning goals; Seijts & Latham, 2011). As many individuals are at the early stages of becoming physically active, which can be considered a complex task (Dishman, 1994; Rhodes & Nigg, 2011; Swann & Rosenbaum, 2018), it appears that learning goals would be frequently more consistent with goal-setting theory than performance goals.

# Mediators of learning goals

Individuals pursuing learning goals may focus on strategies to become active, such as finding an exercise class that fits within their schedule and resources, or identifying walking routes (i.e., knowledge and skill acquisition). It has also been suggested that learning goals activate metacognitive processes, such as searching, planning, monitoring, and the evaluation of strategies, in contrast to performance goals, which activate pre-existing strategies (Wood, Whelan, Sojo, & Wong, 2013). Hence, it is suggested that learning goals lead to an intensified search for task-relevant information required for mastering the task, and in turn increased self-efficacy, while also buffering the impact of negative feedback and subsequent tension or frustration (Seijts et al., 2013). Collectively, these effects can foster improved task performance. Seijts and Latham (2012) summarised that: ‘Learning goals create a psychological safety zone for generating untried, yet potentially promising, ideas for taking constructive action’ (p. 5). That is, rather than focussing on achievement of PA outcomes, learning goals focus more on searching, planning, monitoring, evaluating, and generating ideas or strategies – all of which may be useful in supporting long-term PA behaviour change.

# Learning vs. process goals

Learning goals, as defined by Locke, Latham and colleagues (above) have not yet been tested specifically in a PA context; thus, at present, it remains unclear how well learning goals would apply to PA. This important and contemporary aspect of goal-setting theory should be deemed a high-priority objective for future research in the context of PA. Locke and Latham (2013) noted that ‘In sports … process goals have been found to be very effective for training and development and are similar, if not identical, to learning goals’ (p. 624). Process goals focus on the execution of behaviours, skills and strategies which are important to performance in the task (Kingston & Wilson, 2008) and ‘specify behaviours in which the performer will engage during performance’ (Kingston & Hardy, 1997, p. 279). Process goals have been associated with less anxiety, greater levels of confidence, enhanced concentration, greater satisfaction and improved performance compared to outcome-focused goals (Kingston & Hardy, 1997; Pierce & Burton, 1998; Weinberg, 2013).

Despite their similarities, however, it appears that there are substantive differences between learning goals and process goals that are worth considering. Process goals are not explicitly focussed on acquiring new knowledge or skills but, rather, are about executing existing strategies. For example, process goals could be to ‘walk at a brisk pace’, or to ‘maintain a heart rate between 90–125 bpm while walking’. Instead, learning goals might be to ‘find three ways of fitting a 10-minute walk into your day’ or to ‘identify five effective strategies to walk more this week.’ Furthermore, learning goals inherently involve learning how to perform a task—that is, they focus on the acquisition and development of the skills and knowledge that are required to carry out the task. As such, they are particularly relevant during the early stages of task performance (Locke & Latham, 2002, 2019). However, once the necessarily skills and knowledge have been acquired (i.e., moderators of specific, challenging performance goals have been met), goal-setting theory suggests that learning goals may no longer be optimal for performance enhancement. Conversely, process goals focus on the process of achieving or improving performance (e.g., Kingston & Hardy, 1997). While they too may be relevant during the early stages of development, process goals could also be relevant in later stages (e.g., when the individual is seeking to maintain the desired performance or behaviour). That is, after individuals have learned to perform a task, they may still use process goals to maintain their performance, although it is less likely that they would continue to derive optimal benefits by relying on learning goals. Overall, while there are similarities, it appears that there are also important differences between learning goals and process goals which need to be considered.

# The need for a dynamic perspective

One important implication of recent developments in goal-setting theory, and specifically its expansion to incorporate both learning and performance goals, is the inherent need for a dynamic approach to goal-setting. Specifically, the stage of one’s development in becoming physically active needs to be considered when determining the optimal type of goal that should be set. While learning goals may be recommended in the early stages of learning new complex tasks (e.g., when starting to become active), performance goals will gradually become more appropriate as skills, knowledge, ability and commitment increase (Locke & Latham, 2002, 2013, 2019). By initially concentrating on learning goals, individuals will attend to important behaviours that facilitate skill acquisition and obtain feedback on their progress at a critical developmental stage, processes that, collectively, should help facilitate learning. Once skills are learned, performance goals should be introduced in order to increase effort, persistence, and use of the developed strategies (e.g., Williams, 2013). Indeed, ‘Learning goals often lead to the setting of personal performance goals’ (Latham,

Seijts, & Slocum, 2016, p. 276). In one study, $7 5 \%$ of the participants who were assigned a learning goal also self-set a performance goal, even though they were committed to the learning goal – and the self-set performance goals were a significant predictor of performance (Seijts $\&$ Latham, 2011). That is, individuals who pursue learning goals often then set their own performance goals as a result.

Such a dynamic approach to goal-setting would be in line with a stage-of-change approach to health behaviour (e.g., Schwarzer, Lippke, & Luszczynska, 2011) and could increase likelihood of PA maintenance (e.g., Nigg et al., 2008). This approach would require practitioners to be competent in setting both types of goals, as well as recognising when each goal type should be introduced. This notion also suggests that other approaches to PA promotion, such as mass-media campaigns, should be tailored to both types of goals (and, therefore, should not focus exclusively on performance goals). Understanding whether individuals are new to a task that they perceive to be complex (i.e., they have low skill, knowledge, or ability) should guide goal-setting. In such instances, goal-setting theory does not advocate specific, challenging performance goals and instead alternative approaches (i.e., learning goals) will likely be most beneficial.

# Implications and future directions

Several implications and future directions arise from this review. Researchers, policy makers, educators, and practitioners should be aware that goal-setting theory has evolved beyond performance goals as a one-size-fits-all approach. When adopting goal-setting theory, it is now important that both learning and performance goals be considered, as well as the moderating and mediating factors for each. By doing so, goals could be set more appropriately, effectively, and with less risk of detrimental effects. Specifically, skill, knowledge, ability, commitment, and perceptions of task complexity should be assessed before identifying which type of goal to set. Indeed, a dynamic, multiphasic approach may be required, in which participants should begin by setting learning goals and should switch to specific goals once moderating conditions identified by the theory have been met.

This means that prominent PA promotion initiatives, such as mass-media campaigns, could be more effective by incorporating multiple approaches (e.g., based on learning goals and performance goals). More appropriate alternatives for individuals who have low ability and low commitment should be tested. There is currently limited evidence in the context of PA for learning goals (as articulated by Locke and Latham). Therefore, research is needed to compare learning goals against performance goals in the context of PA, and to determine the effects of each goal type on PA, adherence, and psychological factors (e.g., self-efficacy, motivation, perceptions of failure). In turn, experimental research with adequate follow-up periods is needed to determine whether learning goals, consistent with contemporary goal-setting theory, would be more beneficial in the long run for individuals in the early stages of PA adoption than the approach underpinning current practice, namely setting specific, challenging performance goals.

# Conclusion

The aims of this review were to: (i) critically review core tenets of contemporary goal-setting theory and their application in PA promotion; (ii) discuss consequences and negative implications of setting PA goals inappropriately; (iii) consider alternative goal types that are consistent with current goalsetting theory; and (iv) identify future directions for policy, research and practice. Several key issues are apparent in current goal-setting practice for PA promotion. First, the primary approach to goal-setting in PA promotion is based on performance goals (i.e., the achievement of specific task outcomes such as minutes of moderate-to-vigorous PA, or step counts). These goals are promoted in a one-size-fits-all manner through prominent initiatives, such as national guidelines. However, goal-setting theory has evolved to encompass both performance and learning goals, each of which are appropriate only in particular contexts. This development means that reliance on the one-size-fits-all model focussing on specific, challenging performance goals is no longer consistent with goal-setting theory (i.e., it is now outdated).

Second, goal-setting theory states that specific, challenging performance goals should not be set in the absence of moderating factors (e.g., skill, knowledge, ability, commitment); yet prominent approaches to PA promotion do not explicitly consider such moderators. Approaches based on performance goals are mostly appropriate for individuals who are already active, and may even be problematic for individuals who are at the early stages of become active. That is, current practice may actually be problematic for those whom the guidance is targeting in the first place.

Finally, setting specific, challenging goals can have negative or detrimental effects on a range of potential determinants of long-term participation in exercise and PA (e.g., stress, negative emotions, reduced self-efficacy, perceptions of failure, inhibiting learning). This issue means that current approaches to goal-setting could be contributing to the high dropout and attrition from exercise and PA, in turn reducing the likelihood of achieving health benefits. Together, these problems highlight the urgent need to re-evaluate the theoretical and empirical basis of goal-setting practice in exercise and PA promotion.

# Notes

1. We note that increasing PA and reducing sedentary behaviour are different outcomes (e.g., Prince, Saunders, Gresty, & Reid, 2014). The focus of this review is on promotion of PA specifically. 2. In addition to the four moderators discussed above, other factors are discussed in some instances, such as personality (Locke & Latham, 2013), self-efficacy (Bandura, 2013; Locke & Latham, 2002), and importance (Locke & Latham, 2002) but Locke and Latham typically refer to the four moderators discussed here. 3. The examples of learning goals provided here are based on those reported previously. For example, Seijts and Latham (2005) presented a performance goal to “attain 20 percent market share by the end of the fiscal year” with an equivalent learning goal to “discover three effective strategies to increase market share” (p.128).

# Disclosure statement

No potential conflict of interest was reported by the authors.

# Funding

Simon Rosenbaum is supported by funding from the National Health and Medical Research Council.

# ORCID

Christian Swann $\textcircled { \scriptsize { 1 } }$ http://orcid.org/0000-0003-1502-3179   
Simon Rosenbaum $\textcircled{1}$ http://orcid.org/0000-0002-8984-4941   
Stewart A. Vella $\textcircled{1}$ http://orcid.org/0000-0003-0537-9366   
Desmond McEwan $\textcircled{1}$ http://orcid.org/0000-0001-5118-6421   
Panteleimon Ekkekakis $\textcircled{1}$ http://orcid.org/0000-0003-4260-4702

# References

Anson, D., & Madras, D. (2016). Do low step count goals inhibit walking behavior: A randomized controlled study. Clinical Rehabilitation, 30(7), 676–685.   
Artinian, N. T., Fletcher, G. F., Mozaffarian, D., Kris-Etherton, P., Van Horn, L., Lichtenstein, A. H., … Meininger, J. C. (2010). Interventions to promote physical activity and dietary lifestyle changes for cardiovascular risk factor reduction in adults: A scientific statement from the American Heart Association. Circulation, 122(4), 406–441.   
Bandura, A. (1986). The explanatory and predictive scope of self-efficacy theory. Journal of Social and Clinical Psychology, 4 (3), 359–373.   
Bandura, A. (2013). The role of self-efficacy in goal-based motivation. In E. A. Locke, & G. P. Latham (Eds.), New developments in goal setting and task performance (pp. 147–158). New York, NY: Routledge.   
Bandura, A., & Locke, E. A. (2003). Negative self-efficacy and goal effects revisited. Journal of Applied Psychology, 88(1), 87– 99.   
Beauchamp, M., Crawford, K., & Jackson, B. (2019). Social cognitive theory and physical activity: Mechanisms of behaviour change, critique, and legacy. Psychology of Sport and Exercise, doi:10.1016/j.psychsport.2018.11.009   
Bodenheimer, T., & Handley, M. A. (2009). Goal-setting for behavior change in primary care: An exploration and status report. Patient Education and Counseling, 76(2), 174–180.   
Burg, M. M., Schwartz, J. E., Kronish, I. M., Diaz, K. M., Alcantara, C., Duer-Hefele, J., & Davidson, K. W. (2017). Does stress result in you exercising less? Or does exercising result in you being less stressed? Or is it both? Testing the bi-directional stress- exercise association at the group and person (N of 1) level. Annals of Behavioral Medicine, 51 (6), 799–809.   
Conroy, M. B., Yang, K., Elci, O. U., Gabriel, K. P., Styn, M. A., Wang, J., … Burke, L. E. (2011). Physical activity selfmonitoring and weight loss: 6-month results of the SMART trial. Medicine and Science in Sports and Exercise, 43(8), 1568–1574.   
Dishman, R. K. (1994). Advances in exercise adherence. Champaign, Il: Human Kinetics.   
Dishman, R. K., DeJoy, D. M., Wilson, M. G., & Vandenberg, R. J. (2009). Move to Improve: A randomized workplace trial to increase physical activity. American Journal of Preventive Medicine, 36(2), 133–141.   
Drach-Zahavy, A., & Erez, M. (2002). Challenge versus threat effects on the goal– performance relationship. Organizational Behavior and Human Decision Processes, 88(2), 667–682.   
Du, Y., Liu, B., Sun, Y., Snetselaar, L. G., Wallace, R. B., & Bao, W. (2019). Trends in adherence to the physical activity guidelines for Americans for aerobic activity and time spent on sedentary behaviour among US adults, 2007 to 2016. JAMA Network Open, 2(7), e197597.   
Ekelund, U., Steene-Johannessen, J., Brown, W. J., Fagerland, M. W., Owen, N., Powell, K. E., … Lancet Sedentary Behaviour Working Group. (2016). Does physical activity attenuate, or even eliminate, the detrimental association of sitting time with mortality? A harmonised meta-analysis of data from more than 1 million men and women. The Lancet, 388 (10051), 1302–1310.   
Epton, T., Currie, S., & Armitage, C. J. (2017). Unique effects of setting goals on behavior change: Systematic review and meta-analysis. Journal of Consulting and Clinical Psychology, 85(12), 1182–1198.   
Foster, C., Richards, J., Thorogood, M., & Hillsdon, M. (2013). Remote and web 2.0 interventions for promoting physical activity. Cochrane Database of Systematic Reviews, 9. No.: CD010395. doi:10.1002/14651858.CD010395.pub2.   
Glanz, K., & Rimer, B. K. (2005). Theory at a glance: A guide to health promotion practice (2nd ed.). Bethesda, MD: National Cancer Institute.   
Gourlan, M., Bernard, P., Bortolon, C., Romain, A. J., Lareyre, O., Carayol, M., … Boiché, J. (2016). Efficacy of theory-based interventions to promote physical activity: A meta-analysis of randomised controlled trials. Health Psychology Review, 10(1), 50–66.   
Howlett, N., Trivedi, D., Troop, N. A., & Chater, A. M. (2019). Are physical activity interventions for healthy inactive adults effective in promoting behaviour change and maintenance, and which behaviour change techniques are effective? A systematic review and meta-analysis. Translational Behavioral Medicine, 9, 147–157.   
Kingston, K., & Wilson, K. (2008). The application of goal setting in sport. In S. Mellalieu & S. Hanton (Eds.), Advances in applied sport psychology (pp. 85–133). London: Routledge.   
Kingston, K. M., & Hardy, L. (1997). Effects of different types of goals on processes that support performance. The Sport Psychologist, 11(3), 277–293.   
Klein, H., Cooper, J., & Monahan, C. (2013). In E. A. Locke, & G. P. Latham (Eds.), New developments in goal setting and task performance (pp. 65–89). New York, NY: Routledge.   
Kohl, H., Craig, C., Lambert, E., Inoue, S., Alkandari, J., Leetongin, G., … Lancet Physical Activity Series Working Group. (2012). The pandemic of physical inactivity: Global action for public health. The Lancet, 380(9838), 294–305.   
Latham, G. P. (2016). Goal-setting theory: Causal relationships, mediators, and moderators. Oxford Research Encyclopedia of Psychology, doi:10.1093/acrefore/9780190236557.013.12   
Latham, G. P., & Locke, E. A. (1991). Self-regulation through goal setting. Organizational Behavior and Human Decision Processes, 50(2), 212–247.   
Latham, G. P., & Locke, E. A. (2006). Enhancing the benefits and overcoming the pitfalls of goal setting. Organizational Dynamics, 35(4), 332–340.   
Latham, G. P., & Locke, E. A. (2007). New developments in and directions for goal-setting research. European Psychologist, 12(4), 290–300.   
Latham, G. P., & Seijts, G. H. (2016). Distinguished scholar invited essay: Similarities and differences among performance, behavioral, and learning goals. Journal of Leadership & Organizational Studies, 23(3), 225–233.   
Latham, G. P., Seijts, G. H., & Crim, D. (2008). The effects of learning goal difficulty level and cognitive ability on strategies and performance. Canadian Journal of Behavioural Science, 40, 220–229.   
Latham, G. P., Seijts, G., & Slocum, J. (2016). The goal setting and goal orientation labyrinth: Effective ways for increasing employee performance. Organizational Dynamics, 45, 271–277.   
Locke, E. A., & Latham, G. P. (1990). A theory of goal setting & task performance. Englewood Cliffs, NJ: Prentice-Hall.   
Locke, E. A., & Latham, G. P. (2013). New developments in goal setting and task performance. New York, NY: Routledge.   
Locke, E. A., & Latham, G. P. (2015). Breaking the rules: A historical overview of goal- setting theory. In A. J. Elliot (Ed.), Advances in motivation science (Vol. 2, pp. 99–126). Waltham, MA: Academic Press.   
Locke, E. A., & Latham, G. P. (2019). The development of goal setting theory: A half century retrospective. Motivation Science, 5, 93–105.   
Locke, E. A., Shaw, K. N., Saari, L. M., & Latham, G. P. (1981). Goal setting and task performance: 1969–1980. Psychological Bulletin, 90(1), 125–152.   
Marcus, B. H., Williams, D. M., Dubbert, P. M., Sallis, J. F., King, A. C., Yancey, A. K., … Claytor, R. P. (2006). Physical activity intervention studies: What we know and what we need to know: A scientific statement from the American Heart Association Council on Nutrition, Physical Activity, and Metabolism (Subcommittee on Physical Activity); Council on Cardiovascular Disease in the Young; and the Interdisciplinary Working Group on Quality of Care and Outcomes Research. Circulation, 114(24), 2739–2752.   
Markland, D., Ryan, R. M., Tobin, V. J., & Rollnick, S. (2005). Motivational interviewing and self–determination theory. Journal of Social and Clinical Psychology, 24(6), 811–831.   
McEwan, D., Harden, S. M., Zumbo, B. D., Sylvester, B. D., Kaulius, M., Ruissen, G. R., … Beauchamp, M. R. (2016). The effectiveness of multi-component goal setting interventions for changing physical activity behaviour: A systematic review and meta- analysis. Health Psychology Review, 10(1), 67–88.   
Michie, S., West, R., Sheals, K., & Godinho, C. A. (2018). Evaluating the effectiveness of behavior change techniques in health-related behavior: A scoping review of methods used. Translational Behavioral Medicine, 8, 212–224.   
Moon, D. H., Yun, J., & McNamee, J. (2016). The effects of goal variation on adult physical activity behaviour. Journal of Sports Sciences, 34(19), 1816–1821.   
Morris, N. (2019). Fitness app users are ‘trying to cheat step counters’ with this simple hack. Retrieved from https://metro. co.uk/2019/05/16/fitness-app users-trying-cheat-step-counters-simple-hack-9570167/.   
National Institute for Health and Care Excellence. (2014). Behaviour change: Individual approaches. Retrieved from www. nice.org.uk/guidance/ph49.   
Nigg, C. (2013). ACSM’s behavioral aspects of physical activity and exercise. London: Lippincott Williams & Wilkins.   
Nigg, C., Borrelli, B., Maddock, J., & Dishman, R. (2008). A theory of physical activity maintenance. Applied Psychology: An International Review, 57, 544–560.   
Oettingen, G., Wittchen, M., & Gollwitzer, P. (2013). Regulating goal pursuit through mental contrasting with implementation intentions. In E. A. Locke, & G. P. Latham (Eds.), New developments in goal setting and task performance (pp. 523– 548). New York, NY: Routledge.   
O’Halloran, P. D., Blackstock, F., Shields, N., Holland, A., Iles, R., Kingsley, M., … Taylor, N. F. (2014). Motivational interviewing to increase physical activity in people with chronic health conditions: A systematic review and meta-analysis. Clinical Rehabilitation, 28(12), 1159–1171.   
Ordóñez, L. D., Schweitzer, M. E., Galinsky, A. D., & Bazerman, M. H. (2009). Goals gone wild: The systematic side effects of overprescribing goal setting. Academy of Management Perspectives, 23(1), 6–16.   
Pearson, E. S. (2012). Goal setting as a health behavior change strategy in overweight and obese adults: A systematic literature review examining intervention components. Patient Education and Counseling, 87(1), 32–42.   
Pierce, B. E., & Burton, D. (1998). Scoring the perfect 10: Investigating the impact of goal- setting styles on a goal-setting program for female gymnasts. The Sport Psychologist, 12(2), 156–168.   
Playford, E. D., Siegert, R., Levack, W., & Freeman, J. (2009). Areas of consensus and controversy about goal setting in rehabilitation: A conference report. Clinical Rehabilitation, 23(4), 334–344.   
Prestwich, A., Webb, T. L., & Conner, M. (2015). Using theory to develop and test interventions to promote changes in health behaviour: Evidence, issues, and recommendations. Current Opinion in Psychology, 5, 1–5.   
Prince, S., Saunders, T., Gresty, K., & Reid, R. (2014). A comparison of the effectiveness of physical activity and sedentary behaviour interventions in reducing sedentary time in adults: A systematic review and meta-analysis of controlled trials. Obesity Reviews, 15, 905–919.   
Resnicow, K., & McMaster, F. (2012). Motivational interviewing: Moving from why to how with autonomy support. International Journal of Behavioral Nutrition and Physical Activity, 9(1), 19. doi:10.1186/1479-5868-9-19.   
Rhodes, R. E., Janssen, I., Bredin, S. S. D., Warburton, D. E. R., & Bauman, A. (2017). Physical activity: Health impact, prevalence, correlates and interventions. Psychology & Health, 32(8), 942–975.   
Rhodes, R. E., & Nigg, C. R. (2011). Advancing physical activity theory: A review and future directions. Exercise and Sport Sciences Reviews, 39(3), 113–119.   
Schwartz, J., Rhodes, R., Bredin, S. S., Oh, P., & Warburton, D. E. (2019). Effectiveness of approaches to increase physical activity behavior to prevent chronic disease in adults: A brief commentary. Journal of Clinical Medicine, 8(3), 295.   
Schwarzer, R., Lippke, S., & Luszczynska, A. (2011). Mechanisms of health behaviour change in persons with chronic illness or disability: The health action process approach (HAPA). Rehabilitation Psychology, 56, 161–170.   
Schweitzer, M. E., Ordóñez, L., & Douma, B. (2004). Goal setting as a motivator of unethical behavior. Academy of Management Journal, 47(3), 422–432.   
Seijts, G. H., & Latham, G. P. (2001). The effect of distal learning, outcome, and proximal goals on a moderately complex task. Journal of Organizational Behavior: The International Journal of Industrial, Occupational and Organizational Psychology and Behavior, 22(3), 291–307.   
Seijts, G. H., & Latham, G. P. (2005). Learning versus performance goals: When should each be used? Academy of Management Perspectives, 19(1), 124–131.   
Seijts, G. H., & Latham, G. P. (2011). The effect of commitment to a learning goal, self-efficacy, and the interaction between learning goal difficulty and commitment on performance in a business simulation. Human Performance, 24(3), 189–204.   
Seijts, G. H., & Latham, G. P. (2012). Knowing when to set learning versus performance goals. Organizational Dynamics, 1 (41), 1–6.   
Seijts, G. H., Latham, G. P., Tasa, K., & Latham, B. W. (2004). Goal setting and goal orientation: An integration of two different yet related literatures. Academy of Management Journal, 47(2), 227–239.   
Seijts, G. H., Latham, G. P., & Woodwark, M. (2013). Learning goals: A qualitative and quantitative review. In E. A. Locke, & G. P. Latham (Eds.), New developments in goal setting and task performance (pp. 195–212). New York, NY: Routledge.   
Shilts, M. K., Horowitz, M., & Townsend, M. S. (2004). Goal setting as a strategy for dietary and physical activity behavior change: A review of the literature. American Journal of Health Promotion, 19(2), 81–93.   
Shilts, M., Townsend, M., & Dishman, R. (2013). Using goal-setting to promote health behaviour change: Diet and physical activity. In E. A. Locke, & G. P. Latham (Eds.), New developments in goal setting and task performance (pp. 415–438). New York, NY: Routledge.   
Sperandei, S., Vieira, M. C., & Reis, A. C. (2016). Adherence to physical activity in an unsupervised setting: Explanatory variables for high attrition rates among fitness center members. Journal of Science and Medicine in Sport, 19(11), 916–920.   
Stetson, B. A., Rahn, J. M., Dubbert, P. M., Wilner, B. I., & Mercury, M. G. (1997). Prospective evaluation of the effects of stress on exercise adherence in community- residing women. Health Psychology, 16(6), 515–520.   
Strecher, V. J., Seijts, G. H., Kok, G. J., Latham, G. P., Glasgow, R., DeVellis, B., … Bulger, D. W. (1995). Goal setting as a strategy for health behavior change. Health Education Quarterly, 22(2), 190–200.   
Stults-Kolehmainen, M. A., & Sinha, R. (2014). The effects of stress on physical activity and exercise. Sports Medicine, 44(1), 81–121.   
Swann, C., & Rosenbaum, S. (2018). Do we need to reconsider best practice in goal setting for physical activity promotion? British Journal of Sports Medicine, doi:10.1136/bjsports-2017-098186   
Sweller, J., & Levine, M. (1982). Effects of goal specificity on means–ends analysis and learning. Journal of Experimental Psychology: Learning, Memory, and Cognition, 8(5), 463.   
Tasa, K., Whyte, G., & Leonardelli, G. (2013). Goals and negotiation. In E. A. Locke, & G. P. Latham (Eds.), New developments in goal setting and task performance (pp. 397–414). New York, NY: Routledge.   
Tudor-Locke, C., Craig, C. L., Brown, W. J., Clemes, S. A., De Cocker, K., Giles-Corti, B., … Oppert, J. M. (2011). How many steps/day are enough? For adults. International Journal of Behavioral Nutrition and Physical Activity, 8(1), 79. doi:10. 1186/1479-5868-8-79.   
van Sluijs, E. M., van Poppel, M. N., Twisk, J. W., & van Mechelen, W. (2006). Physical activity measurements affected participants’ behavior in a randomized controlled trial. Journal of Clinical Epidemiology, 59, 404–411.   
Weinberg, R. S. (2013). Goal setting in sport and exercise: Research and practical applications. Revista da Educação Física, 24(2), 171–179.   
Wilding, S., Conner, M., Sandberg, T., Prestwich, A., Lawton, R., Wood, C., … Sheeran, P. (2016). The question-behaviour effect: A theoretical and methodological review and meta-analysis. European Review of Social Psychology, 27(1), 196–230.   
Williams, K. (2013). Goal setting in sports. In E. A. Locke, & G. P. Latham (Eds.), New developments in goal setting and task performance (pp. 375–398). New York, NY: Routledge.   
Winters, D., & Latham, G. P. (1996). The effect of learning versus outcome goals on a simple versus a complex task. Group & Organization Management, 21(2), 236–250.   
Wood, R., Whelan, J., Sojo, V., & Wong, M. (2013). Goals, goal orientations, strategies, and performance. In E. A. Locke, & G. P. Latham (Eds.), New developments in goal setting and task performance (pp. 90–114). New York, NY: Routledge.   
World Health Organisation. (2010). Global recommendations on physical activity for health. Geneva, Switzerland: World Health Organization.